--------------------------- MODULE HotelOrderSpec ---------------------------

EXTENDS HotelOrderModel

VARIABLES calledReserve, calledStartPayment

UserNext_Reserve ==
  /\ calledReserve = 0
  /\ calledReserve' = 1
  /\ calledStartPayment' = calledStartPayment
  /\ GRPC_Reserve

UserNext_StartPayment ==
  /\ calledStartPayment = 0
  /\ calledStartPayment' = 1
  /\ calledReserve' = calledReserve
  /\ GRPC_StartPayment

UserNext ==
  \/ UserNext_Reserve
  \/ UserNext_StartPayment

Init ==
  /\ ModelInit
  /\ calledReserve = 0
  /\ calledStartPayment = 0

Next ==
  \/ ModelNext /\ UNCHANGED <<calledReserve, calledStartPayment>>
  \/ UserNext

Spec == Init /\ [][Next]_<<vars, calledReserve, calledStartPayment>>

-----------------------------------------------------------------------------

TypeInvariant == ModelTypeInvariant

StateInvariants ==
  /\ TypeInvariant

THEOREM Spec => StateInvariants

=============================================================================
\* Modification History
\* Last modified Thu Feb 07 21:51:24 MSK 2019 by sandello
\* Created Thu Jan 31 14:31:09 MSK 2019 by sandello
