-------------------------- MODULE TrustInvoiceSpec --------------------------
(* TrustInvoiceSpec animates the model with a simple scheduler
 * and checks invariants and temporal properties.
 *)

EXTENDS TrustInvoiceModel

\* This action enqueues a bit more events into the workflow once its stuck.
UserNext == Len(queue) = 0 /\
  \/ state = "IWS_New"            /\ Enqueue("IE_TPaymentInitialized")
  \/ state = "IWS_WaitForPayment" /\ Enqueue("IE_TRefreshPaymentStatus")
  \/ state = "IWS_Hold"           /\ Enqueue("IE_TPaymentClear")
  \/ state = "IWS_Hold"           /\ Enqueue("IE_TPaymentUnhold")

Init == ModelInit

Next ==
  \/ ModelNext
  \/ UserNext

\* The workflow must eventually either consume an outstanding message
\* or receive a message from the user.
Fairness == WF_vars(ModelNext) /\ WF_vars(UserNext)

Spec == Init /\ [][Next]_vars /\ Fairness

-----------------------------------------------------------------------------

TypeInvariant == ModelTypeInvariant

StateInvariants ==
  /\ TypeInvariant

THEOREM Spec => StateInvariants

=============================================================================
\* Modification History
\* Last modified Thu Feb 07 19:42:49 MSK 2019 by sandello
\* Last modified Wed Jan 30 15:50:09 MSK 2019 by mbobrov
\* Created Mon Jan 28 17:01:35 MSK 2019 by mbobrov
