-------------------------- MODULE TrustPaymentModel -------------------------
(* TrustPaymentModel specifies how we believe Trust processes
 * all the payments made through their API.
 *)

VARIABLE state

AllStates == {
  "TS_None",
  "TS_NotStarted",
  "TS_Started",
  "TS_3dsStarted",
  "TS_Authorized",
  "TS_NotAuthorized",
  "TS_Cleared",
  "TS_Canceled",
  "TS_Refunded"
}

-----------------------------------------------------------------------------
(***************************************************************************)
(* Actions                                                                 *)
(***************************************************************************)

LOCAL Transition(from, to) == (state = from) /\ (state' = to)

CreateOrdersCall == Transition("TS_None", "TS_None")

CreateBasketCall == Transition("TS_None", "TS_NotStarted")

StartPaymentCall == Transition("TS_NotStarted", "TS_Started")

ClearCall == Transition("TS_Authorized", "TS_Cleared")

CancelCall == Transition("TS_Authorized", "TS_Canceled")

RefundCall == Transition("TS_Cleared", "TS_Refunded")

UserStarts3dsStep == Transition("TS_Started", "TS_3dsStarted")

UserAuthorizesPayment ==
  \/ Transition("TS_Started", "TS_Authorized")
  \/ Transition("TS_3dsStarted", "TS_Authorized")

UserNotAuthorizesPayment ==
  \/ Transition("TS_Started", "TS_NotAuthorized")
  \/ Transition("TS_3dsStarted", "TS_NotAuthorized")

BackgroundNext ==
  \/ UserStarts3dsStep
  \/ UserAuthorizesPayment
  \/ UserNotAuthorizesPayment
  
-----------------------------------------------------------------------------

IsAuthorized == state = "TS_Authorized"
IsNotAuthorized == state = "TS_NotAuthorized"

-----------------------------------------------------------------------------
(***************************************************************************)
(* Exploratory Specification                                               *)
(***************************************************************************)

ModelInit == (state = "TS_None")

ModelNext ==
  \/ CreateOrdersCall
  \/ CreateBasketCall
  \/ StartPaymentCall
  \/ ClearCall
  \/ CancelCall
  \/ RefundCall
  \/ BackgroundNext

ModelSpec == ModelInit /\ [][ModelNext]_<<state>>

ModelTypeInvariant == (state \in AllStates)

THEOREM ModelSpec => ModelTypeInvariant

=============================================================================
\* Modification History
\* Last modified Tue Feb 12 18:26:26 MSK 2019 by mbobrov
\* Last modified Tue Feb 05 20:50:25 MSK 2019 by sandello
\* Created Tue Jan 29 15:25:01 MSK 2019 by mbobrov
