package ru.yandex.travel.orders.stress;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

@RequiredArgsConstructor
public enum Outcome {
    SUCCESS("winner", Money.of(7777L, ProtoCurrencyUnit.RUB)),
    SUCCESS_RESERVE_FAILURE_PAYMENT("winner", Money.of(9999L, ProtoCurrencyUnit.RUB)),
    FAILURE_RESERVE("loserreserve", Money.of(7777L, ProtoCurrencyUnit.RUB)),
    FAILURE_CONFIRM("loserconfirm", Money.of(7777L, ProtoCurrencyUnit.RUB));

    @Getter
    private final String familyName;
    @Getter
    private final Money price;
}
