package ru.yandex.travel.orders.stress.config;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.stress.ScenarioRunner;
import ru.yandex.travel.orders.stress.ScenarioService;

@Configuration
@EnableConfigurationProperties(ScenarioProperties.class)
public class ScenarioConfiguration {

    @Bean
    public ScenarioService scenarioService(OrchestratorClientFactory orchestratorClientFactory,
                                           ScenarioProperties properties) {
        return new ScenarioService(
                orchestratorClientFactory, properties.getReservationWait(), properties.getStartPaymentWait(),
                properties.getConfirmationWait(), properties.getPollingInterval(), properties.getMinYandexUID(),
                properties.getMaxYandexUID());
    }

    @Bean
    public ScenarioRunner scenarioRunner(ScenarioService scenarioService, ScenarioProperties properties) {
        ScenarioRunner result = new ScenarioRunner(scenarioService, properties.getMaxRunning(), properties.getPeriodBetweenOrders());
        result.start();
        return result;
    }
}
