package ru.yandex.travel.orders.stress.config;

import java.time.Duration;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "scenario", ignoreUnknownFields = false)
@Data
@Validated
public class ScenarioProperties {

    @NotNull
    private Duration reservationWait;

    @NotNull
    private Duration startPaymentWait;

    @NotNull
    private Duration confirmationWait;

    @NotNull
    private Duration pollingInterval;

    @Positive
    private long minYandexUID;

    @Positive
    private long maxYandexUID;

    @Positive
    private int maxRunning;

    @NotNull
    private Duration periodBetweenOrders;
}
