RECURSE(
#    src/test
)

JAVA_PROGRAM(stress-loader)

JDK_VERSION(11)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

IF(JDK_VERSION != "8")
    PEERDIR(
        contrib/java/javax/xml/bind/jaxb-api/2.3.0 # JDK 11: provides javax.xml.bind.* packages
        contrib/java/com/sun/xml/bind/jaxb-impl/2.3.0
        contrib/java/com/sun/xml/bind/jaxb-core/2.3.0
    )
ENDIF()


PEERDIR(
    travel/library/java/jackson-commons
    travel/library/java/hibernate-commons
    travel/library/java/ha-grpc-client
    travel/library/java/spring-boot-skeleton
    travel/orders/proto/services/orders

    travel/hotels/lib/java/partner_parsers
    travel/hotels/lib/java/commons

    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/javamoney/moneta/moneta-core
    contrib/java/org/javamoney/moneta/moneta-convert
    contrib/java/org/javamoney/moneta/moneta-convert-imf
    contrib/java/org/javamoney/moneta/moneta-convert-ecb

    contrib/java/io/micrometer/micrometer-registry-jmx
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/stress-loader.py
    CUSTOM_PROPERTY appName stress-loader
    CUSTOM_PROPERTY mainClass ru.yandex.travel.orders.stress.StressLoaderApplication
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/io/micrometer/micrometer-registry-jmx/1.1.5
)

LINT(base)
END()
