# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import time as c_time
import uuid
import requests
from datetime import timedelta

from travel.orders.tools.generic_client.common import last_order_info_scenario, happy_page
from travel.orders.tools.generic_client.orch_api import OrchAPI


LAST_NAMES = ["Сугробин", "Иванов", "Петров", "Сидоров"]
PASSPORT_NUMBERS = ["6500112233", "6500112244", "6500112255", "6500112266"]
BIRTH_CERT_NUMBERS = ["XXАБ111111", "XXАБ222222", "XXАБ333333", "XXАБ444444"]


def get_bus_test_context_default_query_params():
    return {
        'bookOutcome': 'BBO_SUCCESS',
        'confirmOutcome': 'BCO_SUCCESS',
        'refundInfoOutcome': 'BRIO_SUCCESS',
        'refundOutcome': 'BRO_SUCCESS',
        'expireAfterSeconds': 0,
    }


def create_bus_order_request(args, offer_id, label, bus_test_context_token=None, payment_test_context_token=None):
    def create_full_ticket(i):
        return {
            "ticket_type": "FULL",
            "seat": "1",
            "passenger": {
                "first_name": "Илья",
                "patronymic": "Викторович",
                "last_name": LAST_NAMES[i],
                "birth_date": "1990-01-01",
                "document_number": PASSPORT_NUMBERS[i],
                "document_type": "ru_national_passport",
                "sex": "male",
                "citizenship": 225
            }
        }

    def create_bus_service(o):
        result_service = {
            "tickets": [],
            "offer_id": o,
        }
        index = 0
        for i in range(args.full):
            result_service["tickets"].append(create_full_ticket(index))
            index += 1
        # for i in range(args.child):
        # for i in range(args.baby):
        return result_service

    result = {
        "deduplication_key": str(uuid.uuid4()),
        "label": label,
        "contact_info": {
            "phone": args.phone,
            "email": args.email,
        },
        "user_info": {
            "ip": "1.2.3.4",
            "region_id": 213,
            "yandex_uid": args.yandex_uid,
            "geo_id": 213,
        },
        "order_history": [],
        "buses_services": [create_bus_service(offer_id)]
    }
    if payment_test_context_token:
        result['payment_test_context_token'] = payment_test_context_token
    if bus_test_context_token:
        for service in result['buses_services']:
            service['bus_test_context_token'] = bus_test_context_token
    return result


# TODO добавить фильтрацию по партнеру
def find_ride_id(args, ride_date, retry_amount=0):
    if retry_amount >= 7:  # Max searching week ahead
        logging.warning("Too many retries")
        return None
    from_id = args.bus_ride_from
    to_id = args.bus_ride_to
    logging.info("Ищем рейс на {} из {} в {}".format(ride_date, from_id, to_id))
    response = requests.get(
        "http://{host}:{port}/api/search?v=2&date={date}&from-id={from_id}&to-id={to_id}".format(
            host=args.bus_backend_api_host,
            port=args.bus_backend_api_port,
            date=ride_date,
            from_id=from_id,
            to_id=to_id
        ),
        headers={
            "Content-Type": "application/json",
            "X-Ya-YandexUid": args.yandex_uid,
            "X-Ya-Session-Key": args.sessionid
        },
        timeout=args.timeout,
    )
    logging.debug("{} => {}".format(response.request.url, response.status_code))
    logging.debug(response.text)
    if response.status_code >= 400:
        return None
    resp_json = response.json()
    if not resp_json:
        c_time.sleep(1)
        return find_ride_id(args, ride_date + timedelta(days=1), retry_amount + 1)
    return resp_json[0]['Id']


def main(args):
    orc_api = OrchAPI(args)

    if args.last:
        last_order_info_scenario(orc_api)
        return

    if not args.bus_ride_id:
        ride_date = args.bus_ride_date
        args.bus_ride_id = find_ride_id(args, ride_date)
        if not args.bus_ride_id:
            logging.error('Cannot find bus_ride_id, add option: --bus-ride-id <ride-id>')
            return

    test_context_token = None
    payment_test_context_token = None

    ride_offer = orc_api.create_ride_offer(args.bus_ride_id)
    if "error" in ride_offer:
        logging.error(ride_offer["error"])
        return

    if args.bus_test_context:
        test_context_token = orc_api.get_bus_test_context_token(get_bus_test_context_default_query_params())

    if args.mock_payment:
        payment_test_context_token = orc_api.get_test_context_payment_token()
    req = create_bus_order_request(args, ride_offer["offerId"], ride_offer["label"] or None, test_context_token, payment_test_context_token)
    logging.info(req)
    order_uid = orc_api.create_order(req)

    logging.info("Создали заказ %s", order_uid)

    while True:
        status_data = orc_api.get_status(order_uid)
        if status_data["state"] == "RESERVED":
            break
        elif status_data["state"] == "CANCELLED":
            logging.info("Ошибка бронирования заказа %s", order_uid)
            orc_api.get_order_info(order_uid)
            return
        c_time.sleep(3)

    orc_api.start_payment(order_uid)
    logging.info("Запустили оплату")

    while True:
        status_data = orc_api.get_status(order_uid)
        if status_data["state"] == "WAITING_PAYMENT":
            break
        c_time.sleep(1)
    logging.info("Заказ ожидает оплаты %s", order_uid)

    order_info = orc_api.get_order_info(order_uid)
    payment_url = order_info['payment']['payment_url']
    logging.info("Ссылка на форму оплаты: %s", payment_url)

    while True:
        status_data = orc_api.get_status(order_uid)
        if status_data["state"] == "CONFIRMED":
            break
        c_time.sleep(2)
    logging.info("Билеты выкуплены")

    order_info = orc_api.get_order_info(order_uid, source='ORDER_PAGE')

    if args.refund:
        refund_part_info = order_info['services'][0]['refund_part_info']
        if refund_part_info['state'] != 'ENABLED':
            logging.error('Cannot refund!')
            return

        refund_amount_rsp = orc_api.calculate_refund_amount({
            'order_id': order_uid,
            'refund_part_contexts': [refund_part_info['context']]
        })
        logging.info("Запросили сумму к возврату")

        version_hash = status_data['version_hash']
        orc_api.start_refund({'order_id': order_uid, 'refund_token': refund_amount_rsp['refund_token']})
        logging.info("Запустили возврат")

        while True:
            status_data = orc_api.get_status(order_uid)
            if status_data["state"] in {"CONFIRMED", "REFUNDED"} and version_hash != status_data['version_hash']:
                break
            c_time.sleep(2)
        logging.info("Билеты возвращены")

    happy_page(orc_api, order_uid)

    logging.info("Счастливого пути!")
