# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import json
import logging
import time


def log_json(data_or_str, log_level=logging.INFO):
    if isinstance(data_or_str, basestring):
        data = json.loads(data_or_str)
    else:
        data = data_or_str

    logging.log(log_level, json.dumps(data, indent=4).decode("unicode_escape"))


def last_order_info_scenario(orc_api):
    result = orc_api.get_order_info(orc_api.get_last_order_uid())
    log_json(json.dumps(result, indent=4))


def takeout_get_scenario(orc_api):
    takeout_start_resp = orc_api.start_takeout_get()

    for _ in range(20):
        takeout_result_resp = orc_api.get_takeout_result(takeout_start_resp)
        if takeout_result_resp['status'] == 'pending':
            time.sleep(1)
        else:
            log_json(takeout_result_resp['data']['orders.json'])
            break
    else:
        logging.error("Can't get takeout result")


def takeout_delete_scenario(orc_api):
    status = orc_api.takeout_status()
    if status['status'] != 'ok':
        raise Exception("Takeout status is not OK: {}".format(status['errors']))
    if status['data'][0]['state'] == 'empty':
        logging.info("Nothing to delete, exiting")
        return
    if status['data'][0]['state'] == 'in_progress':
        logging.info("Deletion in progress, exiting")
        return

    orc_api.start_takeout_delete()

    for _ in range(20):
        status = orc_api.takeout_status()
        if status['status'] != 'ok':
            raise Exception("Takeout status is not OK: {}".format(status['errors']))
        if status['data'][0]['state'] == 'empty':
            logging.info("Deletion complete")
            break
        time.sleep(1)


def happy_page(orc_api, order_id):
    orc_api.happy_page(order_id)
