# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import argparse
import logging
import sys
from datetime import date, timedelta

from travel.orders.tools.generic_client import buses
from travel.orders.tools.generic_client import train
from travel.orders.tools.generic_client import trains_search
from travel.orders.tools.generic_client.common import happy_page, takeout_get_scenario, takeout_delete_scenario
from travel.orders.tools.generic_client.orch_api import OrchAPI
from travel.orders.tools.generic_client.suburban import suburban


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-v", "--verbose", action="store_true", default=False)
    parser.add_argument("--host", default="localhost")
    parser.add_argument("--port", default=8090)
    parser.add_argument("--train-offer-host", default="testing.offer-storage.internal.rasp.yandex.net")
    parser.add_argument("--train-offer-port", default=443)
    parser.add_argument("--bus-backend-api-host", default="0.0.0.0")
    parser.add_argument("--bus-backend-api-port", default=9000)
    parser.add_argument("--timeout", default=20, type=int)

    parser.add_argument("--phone", default="+71234567890")
    parser.add_argument("--email", default="user@example.org")
    parser.add_argument("--yandex-uid", default="32431324")
    parser.add_argument("--sessionid", default="2412412341")
    parser.add_argument("--passport-id", default="")
    parser.add_argument("--icookie", default="")

    parser.add_argument("--skip-authentication", action='store_true', default=False)
    parser.add_argument("--tvm-self-service-id", default=2010758, type=int)
    parser.add_argument("--tvm-api-service-id", default=2002548, type=int)
    parser.add_argument("--tvm-train-offers-service-id", default=2020160, type=int)

    # https://yav.yandex-team.ru/secret/sec-01dq7mb8jqy94m0s5bypb8dn6b/explore/version/ver-01dq7mb8q9b9xgjm5qrmrh32w7
    parser.add_argument("--tvm-client-secret")

    parser.add_argument("--service-ticket")
    parser.add_argument("--user-ticket")

    parser.add_argument("--cancel", action='store_true', default=False)
    parser.add_argument("--round", action='store_true', default=False)
    parser.add_argument("--transfer", action='store_true', default=False)
    parser.add_argument("--mock-payment", action='store_true', default=False)
    parser.add_argument("--mock-payment-code", default="")
    parser.add_argument("--mock-payment-desc", default="")
    parser.add_argument("--mock-im", action='store_true', default=False)
    parser.add_argument("--mock-suburban", action='store_true', default=False)
    parser.add_argument("--mock-suburban-token", default="")
    parser.add_argument("--refund", action='store_true', default=False)
    parser.add_argument("--office-refund", action='store_true', default=False)
    parser.add_argument("--insurance-confirm-fail", action='store_true', default=False)
    parser.add_argument("--insurance", action='store_true', default=False)
    parser.add_argument("--full", default=1, type=int)
    parser.add_argument("--child", default=0, type=int)
    parser.add_argument("--baby", default=0, type=int)
    parser.add_argument("--places", nargs='+', default=[], type=int)

    parser.add_argument("--last", action='store_true', default=False)
    parser.add_argument("--takeout-get", action='store_true', default=False)
    parser.add_argument("--takeout-delete", action='store_true', default=False)

    parser.add_argument("--suburban", action='store_true', default=False)
    parser.add_argument("--suburban-selling-order", action='store_true', default=False)  # buy via suburban-selling, not orc
    parser.add_argument("--suburban-selling-host", default="https://testing.suburban-selling.rasp.yandex.net")
    parser.add_argument("--suburban-export-host", default="https://testing.export.rasp.yandex.net")
    parser.add_argument("--suburban-provider", default="movista")
    parser.add_argument("--suburban-carrier", default="")

    parser.add_argument("--bus", action='store_true', default=False)
    parser.add_argument("--bus-test-context", action='store_true', default=False)
    parser.add_argument("--bus-ride-id", default='')
    parser.add_argument("--bus-ride-date", default=date.today()+timedelta(days=1))
    parser.add_argument("--bus-ride-from", default='c213')
    parser.add_argument("--bus-ride-to", default='c193')

    parser.add_argument("--happy-page-only", action='store_true', default=False)
    parser.add_argument("--get-order", action='store_true', default=False)
    parser.add_argument("--order-id", default='')

    parser.add_argument("--trains-search", action='store_true', default=False)
    parser.add_argument("--trains-direction", action='store_true', default=False)

    args = parser.parse_args()
    logging.basicConfig(level=(logging.DEBUG if args.verbose else logging.INFO),
                        format="%(asctime)-15s | %(levelname)s | %(message)s",
                        stream=sys.stdout)

    if args.happy_page_only:
        orc_api = OrchAPI(args)
        order_id = args.order_id
        happy_page(orc_api, order_id)
        return

    if args.get_order:
        orc_api = OrchAPI(args)
        orc_api.get_admin_order_info(args.order_id)
        return

    if args.takeout_get:
        orc_api = OrchAPI(args)
        takeout_get_scenario(orc_api)
        return

    if args.takeout_delete:
        orc_api = OrchAPI(args)
        takeout_delete_scenario(orc_api)
        return

    if args.suburban:
        suburban.main(args)
    elif args.bus:
        buses.main(args)
    elif args.trains_search or args.trains_direction:
        trains_search.main(args)
    else:
        train.main(args)


if __name__ == "__main__":
    main()
