# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json
import logging

import requests


class ExportClient(object):
    def __init__(self, host):
        self.host = host

    def call(self, method, handler, params=None, data=None):
        url = '{}/{}'.format(self.host, handler)

        logging.info('{}: {} {}'.format(url, params, data))
        res = requests.request(
            method=method,
            url=url,
            params=params,
            data=data,
        )
        logging.info('{} {}'.format(url, res.status_code))

        try:
            res.raise_for_status()
        except Exception:
            print(res.status_code, res.text)
            raise

        return res.json()

    def search_on_date(self, date, station_from_esr, station_to_esr):
        handler = 'v3/suburban/search_on_date'
        params = {
            'station_from': station_from_esr,
            'station_to': station_to_esr,
            'date': date,
            'lang': 'ru_RU',
            'add_subtypes': 'true',
            'selling_version': '3',
            'selling_flows': ['validator', 'simple', 'aeroexpress'],
            'selling_barcode_presets': ['PDF417_cppk', 'PDF417_szppk', 'Aztec_mtppk']
        }
        return self.call('GET', handler, params)

    def get_book_data(self, date, station_from_esr, station_to_esr, tariff_type='etrain'):
        result = self.search_on_date(date, station_from_esr, station_to_esr)
        for selling_tariff in result['selling_tariffs']:
            if selling_tariff['type'] == tariff_type:
                book_data = json.loads(selling_tariff['book_data'])
                return book_data, selling_tariff['price']
        else:
            msg = 'Selling tariffs not found %s', json.dumps(result['selling_tariffs'], indent=4)
            raise Exception(msg)
