# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime, timedelta

from travel.orders.tools.generic_client.orch_api import OrchAPI


def main(args):
    orc_api = OrchAPI(args)

    when = datetime.now() + timedelta(days=10)
    if args.trains_search:
        orc_api.trains_search(params={
            'pointFrom': 'c193',
            'pointTo': 'c43',
            'when': when.strftime("%Y-%m-%d"),
        })
    if args.trains_direction:
        orc_api.trains_direction(params={
            # 'fromSlug': 'moscow',
            'fromSlug': 'moscow-oktyabrskaya',
            'toSlug': 'saint-petersburg',
            # 'fromSlug': 'adler-krasnodar-krai',
            # 'fromSlug': 'adler-station',
            # 'toSlug': 'krasnodar',
            # 'fromSlug': 'nukus-train-station',
            # 'toSlug': 'tynda-station',
        })
