# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import os.path

from ticket_parser2.api.v1 import TvmClient, TvmClientStatus, TvmApiClientSettings


def make_tvm_client(client_id, secret, destinations):
    settings = TvmApiClientSettings(
        self_client_id=client_id,
        enable_service_ticket_checking=True,
        enable_user_ticket_checking=False,
        self_secret=secret,
        dsts=destinations,
    )
    client = TvmClient(settings)
    if client.status != TvmClientStatus.Ok:
        raise Exception("tvm client has bad status: " + TvmClient.status_to_string(client.status))
    return client


def get_tvm_service_ticket(tvm_client_id, tvm_service_id, tvm_client_secret, skip_authentication, logger=None,
                           self_app_name='orchestrator'):
    if skip_authentication:
        return None
    secret = tvm_client_secret
    if not secret:
        if 'TVM_SECRET' in os.environ:
            secret = os.environ['TVM_SECRET']
        else:
            path_to_secret = os.path.join(os.environ.get('HOME'), '.travel/' + self_app_name + '.secret')
            if os.path.exists(path_to_secret):
                with open(path_to_secret) as f:
                    secret = f.readline().strip()
            else:
                message = ("TVM-секрет должен быть указан параметром `--tvm-client-secret`, "
                           "переменной окружения `TVM_SECRET или в файле " + path_to_secret)
                logger.error(message) if logger else print(message)
                raise Exception("TVM_SECRET_NOT_SET")
    tvm_client = make_tvm_client(tvm_client_id, secret, {'dst_service': tvm_service_id})
    ticket = tvm_client.get_service_ticket_for("dst_service")
    return ticket
