import argparse
import logging
import concurrent.futures

from travel.orders.tools.order_logs_patcher.patcher import Patcher
from travel.orders.tools.order_logs_patcher.ydb import YdbProvider

YDB_ENDPOINT = {
    'production': 'ydb-ru.yandex.net:2135',
    'testing': 'ydb-ru-prestable.yandex.net:2135'
}
YDB_DATABASE = {
    'production': '/ru/travelorchetsrator/prod/order_logs_prod',
    'testing': '/ru-prestable/travelorchetsrator/testing/order_logs_testing',
}


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-v", "--verbose", action="store_true", default=False)

    parser.add_argument("--ydb-token")
    parser.add_argument("--ydb-endpoint")
    parser.add_argument("--ydb-database")
    parser.add_argument("--log-table-name", default='order_logs')
    parser.add_argument("--env", default="testing")
    parser.add_argument("--start-uid", default="00000000-0000-0000-0000-000000000000")
    parser.add_argument("--rows-limit", default=5000, type=int)
    parser.add_argument("--skipped-uids-limit", default=100, type=int)
    parser.add_argument("--max-uid-offset", default=10000, type=int)

    args = parser.parse_args()
    logging.basicConfig(level=(logging.DEBUG if args.verbose else logging.INFO),
                        format="%(asctime)-15s | %(levelname)s | %(message)s",
                        filename='patcher.log')

    args.ydb_endpoint = args.ydb_endpoint or YDB_ENDPOINT[args.env]
    args.ydb_database = args.ydb_database or YDB_DATABASE[args.env]

    pool_size=10
    with YdbProvider(args.ydb_endpoint, args.ydb_database, args.ydb_token, pool_size) as ydb_provider:
        with concurrent.futures.ThreadPoolExecutor(max_workers=pool_size) as executor:
            patcher = Patcher(args, ydb_provider, executor)
            patcher.start()


if __name__ == "__main__":
    main()
