import ydb


class YdbProvider(object):
    def __init__(self, endpoint, database, auth_token, pool_size):
        self.connection_params = ydb.DriverConfig(
            endpoint=endpoint, database=database, auth_token=auth_token
        )
        self._pool_size = pool_size
        self._driver = None
        self._session_pool = None

    def get_session_pool(self):
        return self._session_pool

    def get_driver(self):
        return self._driver

    def __enter__(self):
        self._driver = ydb.Driver(self.connection_params)
        self._driver.__enter__()
        self._driver.wait(timeout=10)
        self._session_pool = ydb.SessionPool(self._driver, size=self._pool_size)
        self._session_pool.__enter__()
        return self

    def __exit__(self, *args):
        self._session_pool.__exit__(*args)
        self._driver.__exit__(*args)
