# -*- coding: utf-8 -*-

from django.contrib import admin

from route_search.models import NearestSuburbanDirection


@admin.register(NearestSuburbanDirection)
class NearestSuburbanDirectionAdmin(admin.ModelAdmin):
    search_fields = [
        'settlement__title', 'station__title', 'transport_center__title',
        'settlement__title_ru', 'station__title_ru', 'transport_center__title_ru',
    ]
    raw_id_fields = ['settlement', 'transport_center', 'station']
    list_display = ['settlement', 'transport_center', 'station']
