# coding: utf-8

import warnings

from django.conf import settings
from django.apps import AppConfig
from django.utils.deprecation import RemovedInNextVersionWarning

from common.db.switcher import switcher


class RaspAdminAppConfig(AppConfig):
    name = 'admin'
    label = 'raspadmin'

    def ready(self):
        if getattr(settings, 'APPLIED_CONFIG', None) == 'production':
            warnings.simplefilter('ignore', RemovedInNextVersionWarning)
        from patch_migration_writer import patch_migration_writer
        patch_migration_writer()

        switcher.sync_db()
