# -*- coding: utf-8 -*-

from django.utils.html import escape

from travel.rasp.admin.admin.blue.views import www_station_to_json, flags_to_json


def package_to_json(package):
    city, region, country = package.get_city_region_coutry()

    return {
        'id': package.id,
        'title': unicode(package),
        't_type_id': package.t_type_id,
        'center': [city.longitude, city.latitude],
        'country': {'id': country.id, 'title': country.L_title()} if country else None,
        'region': {'id': region.id, 'title': region.L_title()} if region else None,
        'city': {
            'id': city.id,
            'title': city.L_title(),
            'lon': city.longitude,
            'lat': city.latitude
        } if city else None
    }


def thread_to_json(thread):
    return {
        'id': thread['id'],
        'title': thread['title'],
        'unmapped': thread['stations_count'] - thread['mapped'],
        'originalThreads': thread['original_threads_data'],
        'setting': thread['setting']
    }


def thread_settings_to_json(thread_settings):
    return {
        'id': thread_settings.id,
        'package_id': thread_settings.package_id,
        'path_key': thread_settings.path_key,
        'allow_to_import': thread_settings.allow_to_import,
        'apply_base_stations': thread_settings.apply_base_stations,
        'timezone_override': thread_settings.timezone_override
    }


def station_to_json(s):
    data = {
        'id': s.id,
        'code': s.code,
        'title': s.title,
        'real_title': s.real_title,
        'geocode_title': s.geocode_title,
        'additional_info': escape(s.additional_info or ''),
        'lon': s.longitude,
        'lat': s.latitude,
    }

    # Это хак чтобы сильно не переделывать бэкенд
    if getattr(s, 'index', None):
        data['number'] = s.index
    if getattr(s, 'allow_fuzzy', None):
        data['allow_fuzzy'] = s.allow_fuzzy
    if getattr(s, 'thread_id', None):
        data['thread_id'] = s.thread_id
    if getattr(s, 'fuzzy_flag', None):
        data['fuzzy_flag_id'] = s.fuzzy_flag and s.fuzzy_flag.id or '',

    if s.station_mapping:
        www_station = s.station_mapping.station
        data['www_station'] = www_station_to_json(www_station)

        if www_station.longitude and www_station.latitude:
            data['www_station'].update({
                'lon': www_station.longitude,
                'lat': www_station.latitude,
            })
            data.update({
                'lon': www_station.longitude,
                'lat': www_station.latitude
            })
    else:
        data['www_station'] = None

    if getattr(s, 'fuzzy_flag', None):
        data.update(s.fuzzy_flag and flags_to_json(s.fuzzy_flag) or {})

    return data
