# -*- coding: utf-8 -*-

from __future__ import absolute_import

from django.conf.urls import url

from travel.rasp.admin.admin.blue.api import (
    packages, threads, threads_save_setting, stations_list, station, station_map, station_unmap
)
from travel.rasp.admin.admin.blue.views import (
    admin, thread, stations, station_move, station_action, www_station_set_majority, info, geocode, new
)

urlpatterns = [
    url(r'^(?:(?P<package_id>\d+)/)?$', admin, name='admin'),

    url(r'^thread/(?P<thread_id>(?:\d+))/$', thread),
    url(r'^stations/$', stations),
    url(r'^station_move/(?P<station_id>\d+)/', station_move),

    url(r'^station/(?P<tsi_station_id>\d+)?/?', station_action),
    url(r'^station_set_majority/', www_station_set_majority),

    url(r'^info/(?P<what>.+)/(?P<id>\d+)/$', info),

    url(r'^geocode/$', geocode, name='admin_blue_geocode'),

    url(r'^new/$', new, name='admin_blue'),

    url(r'^api/packages/?$', packages),
    url(r'^api/threads/?$', threads),
    url(r'^api/threads/save-setting/$', threads_save_setting),
    url(r'^api/stations/?$', stations_list),
    url(r'^api/stations/(?P<tsi_station_id>\d+)?/?$', station),
    url(r'^api/stations/(?P<tsi_station_id>\d+)?/map/?$', station_map),
    url(r'^api/stations/(?P<tsi_station_id>\d+)?/unmap/?$', station_unmap),
]
