# -*- coding: utf-8 -*-
from django.conf.urls import url

from travel.rasp.admin.admin.lime.views import (
    admin, threads, thread_segments, moved_stations, station_segments, station_all_segments,
    save_route_path, remove_route_path
)

urlpatterns = [
    url(r'^$', admin, name='admin_lime'),

    url(r'^threads/(?P<package_id>(?:\d+))/$', threads),
    url(r'^thread/(?P<thread_id>(?:\d+))/segments/$', thread_segments),

    url(r'^moved_stations/$', moved_stations),
    url(r'^station/(?P<station_id>(?:\d+))/segments/$', station_segments),
    url(r'^station/(?P<station_id>(?:\d+))/segments/all/$', station_all_segments),

    url(r'^save_route_path/$', save_route_path),
    url(r'^remove_route_path/$', remove_route_path)
]
