# -*- coding: utf-8 -*-

from django.contrib import admin

from travel.rasp.admin.lib.admin_options import RaspExportModelAdmin

from travel.rasp.admin.admin.maintenance_settings.models import Script, UserPermission


class ScriptAdmin(RaspExportModelAdmin):
    list_display = ('code', 'title', 'order', 'on_work', 'on_service')
    list_filter = ('on_work', 'on_service')
    ordering = ('order', )


admin.site.register(Script, ScriptAdmin)


class UserPermissionAdmin(RaspExportModelAdmin):
    raw_id_fields = ('script', 'user')

    list_display = ('script', 'user', 'can_run')
    list_filter = ('script', 'user')


admin.site.register(UserPermission, UserPermissionAdmin)
