# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Script',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u041a\u043e\u0434 \u0441\u043a\u0440\u0438\u043f\u0442\u0430')),
                ('title', models.CharField(max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430')),
                ('button_text', models.CharField(max_length=100, verbose_name='\u0422\u0435\u043a\u0441\u0442 \u043a\u043d\u043e\u043f\u043a\u0438')),
                ('warning_text', models.CharField(default='', help_text='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430\u0434 \u043a\u043d\u043e\u043f\u043a\u043e\u0439 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0441\u043a\u0440\u0438\u043f\u0442\u0430', max_length=255, verbose_name='\u0422\u0435\u043a\u0441\u0442 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),
                ('on_work', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043d\u0430 \u0431\u043e\u0435\u0432\u043e\u043c \u0438\u043d\u0441\u0442\u0430\u043d\u0441\u0435')),
                ('on_service', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u043c \u0438\u043d\u0441\u0442\u0430\u043d\u0441\u0435')),
                ('on_migration', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043d\u0430 \u043c\u0438\u0433\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u043c \u0438\u043d\u0441\u0442\u0430\u043d\u0441\u0435')),
            ],
            options={
                'verbose_name': 'maintenance \u0441\u043a\u0440\u0438\u043f\u0442',
                'verbose_name_plural': 'maintenance \u0441\u043a\u0440\u0438\u043f\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='UserPermission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('can_run', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u043a')),
                ('script', models.ForeignKey(verbose_name='\u0421\u043a\u0440\u0438\u043f\u0442 maintenance', to='maintenance_settings.Script')),
                ('user', models.ForeignKey(verbose_name='\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '\u043f\u0440\u0430\u0432\u043e \u043d\u0430 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u043a\u0440\u0438\u043f\u0442\u0430',
                'verbose_name_plural': '\u043f\u0440\u0430\u0432\u0430 \u043d\u0430 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='script',
            name='permissions',
            field=models.ManyToManyField(to=settings.AUTH_USER_MODEL, through='maintenance_settings.UserPermission'),
        ),
        migrations.AlterUniqueTogether(
            name='userpermission',
            unique_together=set([('script', 'user')]),
        ),
    ]
