# -*- coding: utf-8 -*-

from django.contrib.auth.models import User
from django.db import models
from django.utils.translation import ugettext_lazy as _


class Script(models.Model):
    code = models.CharField(_(u'Код скрипта'), max_length=100, unique=True)

    title = models.CharField(_(u'Название скрипта'), max_length=100)
    button_text = models.CharField(_(u'Текст кнопки'), max_length=100)
    warning_text = models.CharField(_(u'Текст предупреждения'), max_length=255,
                                    help_text=_(u'Показывается над кнопкой запуска скрипта'),
                                    blank=True, default=u'')

    on_work = models.BooleanField(_(u'Разрешен на боевом инстансе'), default=False)
    on_service = models.BooleanField(_(u'Разрешен на сервисном инстансе'), default=False)

    order = models.IntegerField(_(u'Порядок'), default=0, null=False, blank=True)

    permissions = models.ManyToManyField(User, through='UserPermission')

    class Meta:
        verbose_name = _(u'maintenance скрипт')
        verbose_name_plural = _(u'maintenance скрипты')

    def __unicode__(self):
        return self.title


class UserPermission(models.Model):
    script = models.ForeignKey(Script, verbose_name=_(u'Скрипт maintenance'))
    user = models.ForeignKey(User, verbose_name=_(u'Пользователь'))

    can_run = models.BooleanField(_(u'Разрешить запуск'), default=False)

    class Meta:
        unique_together = ('script', 'user')
        verbose_name = _(u'право на запуск скрипта')
        verbose_name_plural = _(u'права на запуск скриптов')

    def __unicode__(self):
        return self.script.title + u': ' + self.user.get_full_name()
