# -*- coding: utf-8 -*-

import logging
import os
import pickle
import sys

from django.conf import settings
from django.core.management.base import BaseCommand
from django.utils import translation

from travel.rasp.admin.lib.osutils import setproctitle


log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = u'''
    Команда для запуска админских задач
    '''

    @translation.override('ru')
    def handle(self, task_data=None, **kwargs):
        if task_data:
            task = pickle.loads(task_data)
        else:
            task = pickle.load(sys.stdin)

        task_log = task['task_log']

        with task_log.capture_log(capture_stdstreams=True):
            # FIXME: Создать класс Task, который должен будет за это отвечать.
            proc_title = '[admin-task]-[{}]-[{}]-[{}]'.format(settings.INSTANCE_ROLE.code, task_log.name,
                                                              str(task_log.created_at))
            log.info(u'Запустили %s %s', os.getpid(), proc_title)
            if settings.ADMIN_TASK_RUN_IN_SEPARATE_PROCESS:
                setproctitle(proc_title)

            sys.stdout.flush()
            sys.stderr.flush()

            task['callable'](*task.get('args', []), **task.get('kwargs', {}))

            sys.stdout.flush()
            sys.stderr.flush()

            log.info(u'Успешно отработал %s', task_log.name)

