# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings
from django.http import HttpResponseForbidden

from common.data_api.tvm.instance import tvm_factory


log = logging.getLogger(__name__)


class IdmTvmMiddleware(object):
    def process_request(self, request):
        try:
            if request.path.startswith('/dostup'):
                service_ticket_header = request.META.get('HTTP_X_YA_SERVICE_TICKET')
                if not service_ticket_header:
                    return HttpResponseForbidden('Empty X-Ya-Service-Ticket')
                service_ticket = tvm_factory.get_provider().check_service_ticket(service_ticket_header)
                if service_ticket.src in settings.TVM_IDM_CLIENT_IDS:
                    return
                else:
                    message = 'Invalid tvm client_id: {}'.format(service_ticket.src)
                    log.error(message)
                    return HttpResponseForbidden(message)
        except Exception as ex:
            log.exception('IdmTvmMiddleware failed: {}'.format(ex))
            raise
