# -*- coding: utf-8 -*-
"""
При переключении баз хочется в админке видеть 'идет переключение баз' а не ServerError
Данный класс нужно использовать в качестве django middleware
"""

import datetime

from django import http
from django.db import connection
from django.conf import settings

from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job


class CustomMessageInAdminOn500WhenSwitchDB(object):
    def process_exception(self, request, exception):
        if request.path.startswith('/admin'):
            if settings.DEBUG:
                return
            if flags['maintenance'] == job.SWITCH_BASES.flag_value:
                cursor = connection.cursor()
                cursor.execute('SELECT `modified_on` FROM `flags` WHERE `name`="maintenance"')

                modified_on = None
                for row in cursor.fetchall():
                    modified_on = row[0]

                if not modified_on:
                    return http.HttpResponse(u'Идет переключение баз.')

                else:
                    start = modified_on.strftime("%Y-%m-%d %H:%M")
                    elapsed = datetime.datetime.now() - modified_on
                    elapsed_minutes = int(elapsed.total_seconds() / 60)

                    return http.HttpResponse(
                        u'Начиная с {start}, идет переключение баз. Прошло {elapsed} минут.'.format(
                            start=start, elapsed=elapsed_minutes)
                    )
