# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.urlresolvers import reverse
from django.views.decorators.csrf import ensure_csrf_cookie
from django.utils import translation
from django.utils.translation import ugettext

from common.models.geo import CityMajority, StationMajority, StationType
from common.models.transport import TransportType
from common.utils.date import get_time_zone_choices

from travel.rasp.admin.admin.views import geoadmin


@ensure_csrf_cookie
def index(request):
    lang = translation.get_language()
    options = {
        'title': ugettext(u'Фиолетовый геоадмин'),
        'adminType': 'purple',
        'staticUrl': settings.STATIC_URL + 'rasp/geoadmins/',
        'maintenanceStatusUrl': reverse('maintenance_status'),
        'mainInstance': False if settings.SERVICE_INSTANCE else True,
        'lang': lang,
        't_types': dict([(t.id, {u'id': t.id, u'code': t.code, u'title': t.L_title()})
                         for t in TransportType.objects.all()]),
        'station_majorities': [{'id': m.id, 'title': m.title}
                               for m in StationMajority.objects.all()],
        'station_types': [{'id': m.id, 'title': m.L_name()}
                          for m in StationType.objects.all()],
        'city_majorities': [{'id': m.id, 'title': m.title}
                            for m in CityMajority.objects.all()],
        'time_zones': [{'id': tz_name, 'title': tz_title}
                       for tz_name, tz_title in get_time_zone_choices()],
    }

    return geoadmin.render(options, lang)
