# -*- coding: utf-8 -*-

from math import pi, cos, sin, sqrt, asin, atan2

YA_MAPS_EARTH_RADIUS = 6378137.0    # радиус Земли в метрах, используемых в картах


def _radians(degree):
    return (degree * pi) / 180


def _degrees(radians):
    return radians / pi * 180


def to_cartesian(point):
    x = YA_MAPS_EARTH_RADIUS * cos(_radians(point[0])) * cos(_radians(point[1]))
    y = YA_MAPS_EARTH_RADIUS * cos(_radians(point[0])) * sin(_radians(point[1]))
    z = YA_MAPS_EARTH_RADIUS * sin(_radians(point[0]))

    return x, y, z


def to_spherical(point):
    lat = _degrees(asin(point[2] / sqrt(point[0] ** 2 + point[1] ** 2 + point[2] ** 2)))
    lon = _degrees(atan2(point[1], point[0]))

    return lat, lon


def distance(a, b):
    a = to_cartesian(a)
    b = to_cartesian(b)

    return length(subtr(a, b))


def subtr(a, b):
    return a[0] - b[0], a[1] - b[1], a[2] - b[2]


def add(a, b):
    return a[0] + b[0], a[1] + b[1], a[2] + b[2]


def scalar_product(a, b):
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2]


def length(v):
    return sqrt(scalar_product(v, v))


def normalize(v):
    l = length(v)
    if l > 0:
        return v[0] / l, v[1] / l, v[2] / l
    return v


def mult(scalar, v):
    return v[0] * scalar, v[1] * scalar, v[2] * scalar


def project(a, b, p):
    """
    svn.yandex.ru/websvn/wsvn/maps/trunk/masstransit/lib/include/yandex/maps/masstransit/geometry.h
    """
    cartesian_a = to_cartesian(a)
    cartesian_b = to_cartesian(b)
    cartesian_p = to_cartesian(p)

    ab = subtr(cartesian_b, cartesian_a)
    ap = subtr(cartesian_p, cartesian_a)
    bp = subtr(cartesian_p, cartesian_b)

    if scalar_product(ab, ap) <= 0:
        return a
    elif scalar_product(ab, bp) >= 0:
        return b

    ab_normalized = normalize(ab)
    scalar_res = scalar_product(ab_normalized, ap)
    mlt = mult(scalar_res, ab_normalized)
    vec = add(cartesian_a, mlt)

    return to_spherical(vec)
