# -*- coding: utf-8 -*-


from common.models.geo import Settlement


def get_package_center_settlement(package):
    if package.region_id:
        try:
            return package.region.settlement_set.order_by('majority')[0]
        except IndexError:
            pass

    if package.country_id:
        try:
            return package.country.settlement_set.order_by('majority')[0]
        except IndexError:
            pass

    return Settlement.objects.get(pk=Settlement.MOSCOW_ID)


def package_to_json(package):
    center_settlement = get_package_center_settlement(package)

    return {
        'id': package.id,
        'title': unicode(package),
        't_type_id': package.t_type_id,
        't_subtype_id': package.t_subtype_id,
        'center': [center_settlement.longitude, center_settlement.latitude],
        'country': {'id': package.country.id, 'title': package.country.L_title()} if package.country else None,
    }


def metaroute_to_json(thread):
    # Похоже тут на самом деле связь OneToOne
    try:
        route = thread.route_set.all()[0]
    except:
        route = None

    return {
        'id': thread.id,
        'title': thread.title,
        'number': thread.number,
        'apply_base_stations': thread.apply_base_stations,
        'scheme': thread.scheme,
        'comment': thread.comment,
        't_type_id': thread.t_type_id,
        't_subtype_id': thread.t_subtype_id,
        'supplier_id': thread.supplier_id,
        'route': {'id': route.id, 'title': thread.title} if route else None,
        'package_id': thread.package_id
    }


def station_to_json(self):
    def null_bool(val):
        return {None: 'inherit', True: 'yes', False: 'no'}[val]

    return {
        'id': str(self.id),
        'www_station': {
            'id': self.station.id,
            'title': self.station.title,
            'majority_id': self.station.majority.id,
            'is_fuzzy': null_bool(self.station.is_fuzzy),
            'is_searchable_to': null_bool(self.station.is_searchable_to),
            'is_searchable_from': null_bool(self.station.is_searchable_from),
            'in_station_schedule': null_bool(self.station.in_station_schedule),
        },
        'arrival': self.arrival,
        'departure': self.departure,
        'lon': self.station.longitude,
        'lat': self.station.latitude,
        'is_fuzzy': null_bool(self.is_fuzzy),
        'is_searchable_to': null_bool(self.is_searchable_to),
        'is_searchable_from': null_bool(self.is_searchable_from),
        'in_station_schedule': null_bool(self.in_station_schedule),
        'order': self.order,
    }
