# -*- coding: utf-8 -*-

import random

from django import forms

from travel.rasp.admin.admin.red.models import Package, MetaRoute


class PackageForm(forms.ModelForm):
    class Meta:
        model = Package
        fields = ('title',)

#    def __init__(self, *args, **kwargs):
#        super(PackageForm, self).__init__(*args, **kwargs)

    def clean_title(self):
        return self.cleaned_data.get('title', None) or str(random.randint(1000000, 9999999))


class MetaRouteInfoForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super(MetaRouteInfoForm, self).__init__(*args, **kwargs)
        self.fields['number'].widget.attrs["id"] = 'id_route_number'
        self.fields['title'].widget.attrs["id"] = 'id_route_title'
        self.fields['t_type'].empty_label = None
        self.fields['supplier'].empty_label = None

    class Meta:
        model = MetaRoute
        fields = ('t_type', 'supplier', 'number', 'title',)

    def clean_number(self):
        return self.cleaned_data.get('number', None) or str(random.randint(1000000, 9999999))

    def clean_title(self):
        return self.cleaned_data.get('title', None) or str(random.randint(1000000, 9999999))
