# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('importinfo', '0001_initial'),
        ('www', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='MetaRoute',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.TrimmedCharField(default=b'', max_length=44, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', blank=True)),
                ('title', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u0430')),
                ('scheme', common.utils.fields.TrimmedTextField(default=b'', verbose_name='\u0421\u0445\u0435\u043c\u0430 \u043a\u0443\u0440\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('comment', common.utils.fields.TrimmedTextField(default=b'', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('allow_back_pseudo_routes', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0439\u0441\u043e\u0432')),
                ('apply_base_stations', models.BooleanField(default=True, verbose_name='\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \xab\u0431\u0430\u0437\u043e\u0432\u043e\u0441\u0442\u044c\xbb \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u043e\u0432')),
            ],
            options={
                'verbose_name': '\u043c\u0435\u0442\u0430\u0440\u0435\u0439\u0441',
                'verbose_name_plural': '\u043c\u0435\u0442\u0430\u0440\u0435\u0439\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='MetaRouteStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('arrival', models.IntegerField(help_text='\u0412\u0440\u0435\u043c\u044f \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u0434\u043e \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0430\u043d\u0446\u0438\u044e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),
                ('departure', models.IntegerField(help_text='\u0412\u0440\u0435\u043c\u044f \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),
                ('time_inpath', models.IntegerField(default=0, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0432 \u043f\u0443\u0442\u0438')),
                ('order', models.IntegerField(default=0, verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a', editable=False, blank=True)),
                ('is_fuzzy', models.NullBooleanField(default=None, choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')], help_text='\u0442\u043e\u0447\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e', verbose_name='\u041d\u0435\u0447\u0435\u0442\u043a\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435')),
                ('is_searchable_from', models.NullBooleanField(default=None, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('is_searchable_to', models.NullBooleanField(default=None, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('in_station_schedule', models.NullBooleanField(default=None, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('in_thread', models.NullBooleanField(default=None, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('metaroute', models.ForeignKey(verbose_name='\u043c\u0435\u0442\u0430\u0440\u0435\u0439\u0441', to='red.MetaRoute')),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0439', to='www.Station')),
            ],
            options={
                'ordering': ['metaroute', 'order', 'id'],
                'verbose_name': '\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043c\u0435\u0442\u0430\u0440\u0435\u0439\u0441\u0430',
                'verbose_name_plural': '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043c\u0435\u0442\u0430\u0440\u0435\u0439\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Package',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(unique=True, max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430')),
                ('autoimport', models.BooleanField(default=True, help_text='\u041f\u0435\u0440\u0435\u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0431\u043e\u043b\u044c\u0448\u043e\u043c \u0438\u043c\u043f\u043e\u0440\u0442\u0435', verbose_name='\u0410\u0432\u0442\u043e\u0438\u043c\u043f\u043e\u0440\u0442')),
                ('last_import_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', blank=True)),
                ('last_mask_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u0441\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438 \u043d\u0438\u0442\u043e\u043a \u0431\u0443\u0434\u0443\u0442 \u043f\u0443\u0441\u0442\u044b\u043c\u0438', blank=True)),
                ('content_manager', models.ForeignKey(verbose_name='\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440', to='importinfo.ContentManager', null=True)),
                ('country', models.ForeignKey(default=225, verbose_name='C\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
                ('region', models.ForeignKey(verbose_name='\u0420\u0435\u0433\u0438\u043e\u043d', blank=True, to='www.Region', null=True)),
                ('t_subtype', models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u041f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430')),
                ('t_type', models.ForeignKey(default=3, verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'verbose_name': '\u041f\u0430\u043a\u0435\u0442 \u041a\u0413\u0410',
                'verbose_name_plural': '\u041f\u0430\u043a\u0435\u0442\u044b \u041a\u0413\u0410',
            },
        ),
        migrations.AddField(
            model_name='metaroute',
            name='package',
            field=models.ForeignKey(verbose_name='\u041f\u0430\u043a\u0435\u0442 \u041a\u0413\u0410', to='red.Package'),
        ),
        migrations.AddField(
            model_name='metaroute',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='metaroute',
            name='t_subtype',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u041f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='metaroute',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AlterUniqueTogether(
            name='metaroutestation',
            unique_together=set([('metaroute', 'order')]),
        ),
    ]
