# -*- coding: utf-8 -*-

from __future__ import absolute_import

from django.conf.urls import url

from travel.rasp.admin.admin.red.api import (
    packages, package_import, threads, thread, thread_import, stations, station, stations_distances, stations_reorder
)
from travel.rasp.admin.admin.red.views import (
    admin, settlement, metaroute, mrstation_delete, mrstation_add, mrstation_create, package_save, www_goroda,
    route_reorder, route_delete, route_create, route_clone, route_save, import_package, import_metaroute, new
)

from travel.rasp.admin.admin.www_stations.api import www_stations, www_station_move, www_station_join, www_station_change_majority

urlpatterns = [
    url(r'^(?:(?P<package_id>\d+)/)?$', admin, name='admin_red_old'),

    url(r'^info/settlement/(?P<settlement_id>\d+)/$', settlement, name='settlement'),

    url(r'^metaroute/(?P<metaroute_id>\d+)/$', metaroute, name='metaroute'),
    url(r'^mrstation/delete/$', mrstation_delete, name='mrstation_delete'),
    url(r'^mrstation/add/$', mrstation_add, name='mrstation_add'),
    url(r'^mrstation/create/$', mrstation_create, name='mrstation_create'),

    url(r'^package/save/$', package_save, name='package_save'),
    url(r'^route/save/$', route_save, name='route_save'),
    url(r'^route/create/$', route_create, name='route_create'),
    url(r'^route/clone/$', route_clone, name='route_clone'),
    url(r'^route/delete/$', route_delete, name='route_delete'),
    url(r'^route/reorder/$', route_reorder, name='route_reorder'),
    url(r'^import/route/$', import_metaroute, name='import_metaroute'),
    url(r'^import/package/$', import_package, name='import_package'),

    url(r'^www_stations/goroda/$', www_goroda, name='www_stations'),

    url(r'^new/$', new, name='admin_red')
]

# Для обратной совместимости
urlpatterns += [
    url(r'^www_stations/$', www_stations, name='www_stations'),
    url(r'^www_station/move/$', www_station_move, name='www_station_move'),
    url(r'^www_station/join/$', www_station_join, name='www_station_join'),
    url(r'^www_station/change_majority/$', www_station_change_majority, name='www_station_change_majority'),
]

urlpatterns += [
    url(r'^api/packages/?$', packages),
    url(r'^api/packages/(?P<id>\d+)/import/?$', package_import),
    url(r'^api/threads/?$', threads),
    url(r'^api/threads/(?P<id>\d+)/import/?$', thread_import),
    url(r'^api/threads/(?P<id>\d+)/?', thread),
    url(r'^api/stations/?$', stations),
    url(r'^api/stations/(?P<id>\d+)?/?$', station),
    url(r'^api/stations/reorder/?$', stations_reorder),
    url(r'^api/stations/distances/?$', stations_distances),
]
