# -*- coding: utf-8 -*-

import re
from email.header import Header
from StringIO import StringIO

from django.contrib.auth.decorators import login_required
from django.http import HttpResponse
from common.utils.unicode_csv import UnicodeWriter

from common.models.schedule import RThread


@login_required
def export_bus_duplicates(request):
    thread_by_first_last_station = {}

    title_breaker = re.compile(ur'[-,(){}\[\]]', re.U + re.I)

    qs = RThread.objects.filter(route__t_type__code='bus', hidden=False)

    for index, rthread in enumerate(qs.select_related('route__supplier', 'type')):
        titles = list(rthread.rtstation_set.all().values_list('station__title', flat=True))

        title_first = title_breaker.split(titles[0], 1)[0]
        title_last = title_breaker.split(titles[-1], 1)[0]

        supplier = rthread.route.supplier.code

        key = (title_first, title_last)

        thread_by_first_last_station.setdefault(key, {})[supplier] = rthread

    max_length = 1

    for key in list(thread_by_first_last_station.keys()):
        length = len(thread_by_first_last_station[key])

        if length == 1:
            del thread_by_first_last_station[key]
        elif length > max_length:
            max_length = length

    stream = StringIO()

    fields = ['title']

    field_group = ['thread_id', 'type', 'supplier']

    fields = fields + field_group * max_length

    writer = UnicodeWriter(stream, encoding='utf8', delimiter=';')

    writer.writerow(fields)

    for (title_from, title_to), threads_by_supplier in thread_by_first_last_station.items():
        title = title_from + u' - ' + title_to
        row = [title]

        for supplier_code, rthread in threads_by_supplier.items():
            row += [str(rthread.id), rthread.type.code, supplier_code]

        writer.writerow(row)

    response = HttpResponse(stream.getvalue(), content_type="text/csv; charset=utf8")

    response['Content-Disposition'] = 'attachment; filename=%s' % str(Header('report.csv', 'utf8'))

    return response
