# -*- coding: utf-8 -*-

from travel.rasp.admin.lib.maintenance.flags import get_flag_note
from travel.rasp.admin.lib.maintenance.scripts import job

from django import template
from django.conf import settings
from django.utils.translation import ugettext_lazy as _


register = template.Library()


@register.inclusion_tag('admin/block_service_alert.html', takes_context=True)
def service_alert_admin(context):
    job_number = context.get('MAINTENANCE')
    if settings.SERVICE_INSTANCE:
        message = _(u"Сервисная база")
    else:
        message = _(u"Осторожно, боевая база!")

    if job_number:
        message += u"<br />" + job.get_text(job_number)

    note = get_flag_note('maintenance')

    if note:
        message = u'<div class="rasp-service-alert-note" >%s</div>%s' % (note, message)

    return {'message': message}
