# encoding: utf-8

from __future__ import unicode_literals

from django import template
from django.core.urlresolvers import reverse
from django.utils.safestring import mark_safe

from common.models.schedule import Company, RThread
from common.models.transport import TransportModel
from travel.rasp.admin.www.models.schedule import TransportScheme


register = template.Library()


@register.simple_tag
def foreign_objects(obj_id, cls, cls2, title):
    """ Выводит ссылки на объекты класса <cls> (Эти объекты ссылаются на данный)
        либо "отсутствуют"
        либо "" в случае ошибки
        Вход: id объекта на который ссылаются,
              класс объекта, на который ссылаются
              класс объектов, которые ссылаются, либо имя аттрибута foreign manager
              имя атрибута для title-а в теге <a href="..">{title}</a>
        Выход: html
    """
    try:
        obj = cls.objects.get(id=int(obj_id))
    except cls.DoesNotExist:
        return ''

    foreign_name = isinstance(cls2, basestring) and cls2 or (cls2.__name__.lower() + '_set')
    objects = map(
        lambda o: '<a href="{url}">{title}</a>'.format(
            url=reverse('admin:{}_{}_change'.format(
                o.__class__._meta.app_label, o.__class__._meta.model_name
            ), args=(o.id,)),
            model=o.__class__.__name__.lower(), pk=o.id,
            title=getattr(o, title) or str(o) or 'названия нет'
        ),
        getattr(obj, foreign_name).all()
    )

    return objects and mark_safe('&nbsp;'.join(objects)) or 'отсутствуют'


@register.simple_tag
def tm_scheme_objects(obj_id):
    return foreign_objects(obj_id, TransportModel, TransportScheme, 'title')


@register.simple_tag
def comp_scheme_f_objects(obj_id):
    return foreign_objects(obj_id, Company, TransportScheme, 'title')


@register.simple_tag
def thread_thread_f_objects(obj_id):
    return foreign_objects(obj_id, RThread, 'thread_changes', 'number')
