# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.contrib import admin
from django.conf.urls import url, include
from django.utils.translation import ugettext_lazy as _
from filebrowser.sites import site as filebrowser_site

import travel.rasp.admin.admin.views as rasp_admin_views
from travel.rasp.admin.admin.views import dynamic_settings, geomap, tanker, flags


admin.autodiscover()
admin.site.site_header = _('Геоадмин')
admin.site.site_title = _('Геоадмин')

urlpatterns = [
    url(r'^www_stations/', include('travel.rasp.admin.admin.www_stations.urls')),
    url(r'^blue/', include('travel.rasp.admin.admin.blue.urls')),
    url(r'^redmap/', include('travel.rasp.admin.admin.red.urls')),
    url(r'^lime/', include('travel.rasp.admin.admin.lime.urls')),
    url(r'^purple/', include('travel.rasp.admin.admin.purple.urls')),

    url(r'^reports/', include('travel.rasp.admin.admin.reports.urls')),
    url(r'^stats/', include('stats.urls')),

    url(r'^geomap/packages/', geomap.get_packages),
    url(r'^geomap/data/', geomap.get_data),
    url(r'^geomap/search/station/$', geomap.search_station),

    url(r'^quick_tree/?$',
        rasp_admin_views.quick_tree_planet, name="admin_tree"),
    url(r'^quick_tree/planet/(?P<id>\d+)',
        rasp_admin_views.quick_tree_planet, name="admin_tree_planet"),
    url(r'^quick_tree/country/(?P<id>\d+)',
        rasp_admin_views.quick_tree_country, name="admin_tree_country"),
    url(r'^quick_tree/region/(?P<id>\d+)',
        rasp_admin_views.quick_tree_region, name="admin_tree_region"),
    url(r'^quick_tree/settlement/(?P<id>\d+)',
        rasp_admin_views.quick_tree_settlement, name="admin_tree_settlement"),
    url(r'^quick_tree/station/(?P<id>\d+)',
        rasp_admin_views.quick_tree_station, name="admin_tree_station"),

    url(r'^www/rthread/copy_thread/$', rasp_admin_views.copy_thread),

    url(r'^show_file/(?P<app_label>[A-Za-z_]+)/(?P<model>[A-Za-z_]+)/(?P<field_name>[A-Za-z_]+)/(?P<id>\d+)',
        rasp_admin_views.show_file),
    url(r'download_db_file/(?P<app_label>[A-Za-z_]+)/(?P<model_name>[A-Za-z_]+)/(?P<pk>\d+)/(?P<field_name>[A-Za-z_]+)',
        rasp_admin_views.download_db_file, name='admin_download_db_file'),
    url(r'delete_db_file/(?P<app_label>[A-Za-z_]+)/(?P<model_name>[A-Za-z_]+)/(?P<pk>\d+)/(?P<field_name>[A-Za-z_]+)',
        rasp_admin_views.delete_db_file, name='admin_delete_db_file'),

    url(r'^maintenance/$', rasp_admin_views.maintenance),
    url(r'^maintenance/show_cron_run_logs/$', rasp_admin_views.show_cron_run_log_list, name='show_cron_run_logs'),
    url(r'^maintenance/show_last_run_logs/$', rasp_admin_views.show_admin_run_log_list, name='show_last_run_logs'),
    url(r'^maintenance/show_log/(.*)$', rasp_admin_views.show_log, name='admin_show_log'),
    url(r'^recalc_static_pages', rasp_admin_views.recalc_static_pages, name="recalc_static_pages"),

    url(r'^www/afschedulefile/load_zip_file/$', rasp_admin_views.load_zip_file),
    url(r'^www/afsubwayfile/load_zip_file/$', rasp_admin_views.load_subway_zip_file),

    url(r'^www/(?P<modelname>externaldirection|direction)/(?P<pk>\d+)/export/$', rasp_admin_views.export_direction,
        name='admin_export_direction'),
    url(r'^www/(?P<modelname>externaldirection|direction)/(?P<pk>\d+)/reimport/$',
        rasp_admin_views.reimport_direction_view, name='admin_reimport_direction'),
    url(r'^www/(?P<modelname>externaldirection|direction)/import/$', rasp_admin_views.import_direction_view,
        name='admin_import_direction'),

    url(r'^www/externaldirection/load_zip_file/$', rasp_admin_views.load_schemas_zip_file),
    url(r'^www/externaldirection/(?P<pk>\d+)/schema/$', rasp_admin_views.externaldirection_edit_schema,
        name='edit_external_direction_schema'),
    url(r'^www/externaldirection/(?P<pk>\d+)/stations/$', rasp_admin_views.externaldirection_stations),

    url(r'^www/direction/(?P<pk>\d+)/delete_safely/$', rasp_admin_views.direction_delete_safely,
        name='admin_delete_internal_direction_safely'),

    url(r'^www/suburbanzone/import/$', rasp_admin_views.import_suburbanzone_view),

    url(r'^www/district/(?P<district_id>\d+)/import/$', rasp_admin_views.import_district_view),
    url(r'^www/station/load_station_schema_images/', rasp_admin_views.load_station_schema_images_zip_file),
    url(r'^www/teaser/gen_uid/', rasp_admin_views.gen_teaser_uid),
    url(r'^www/trainpseudostationmap/load_map/$', rasp_admin_views.load_trainpseudostationmap,
        name='admin_www_trainpseudostationmap_load'),

    url(r'^upload_schedule_file', rasp_admin_views.upload_schedule_file, name='upload_schedule_file'),
    url(r'^upload_railway_file', rasp_admin_views.upload_railway_file, name='upload_railway_file'),

    url(r'^sindbad_stats/$', rasp_admin_views.sindbad_stats),
    url(r'^gtfs_form/$', rasp_admin_views.gtfs_form, name='admin_gtfs_form'),

    url(r'^filebrowser/', include(filebrowser_site.urls)),
    url(r'maintenance_status/$', rasp_admin_views.get_maintenance_status, name='maintenance_status'),
    url(r'configuration/$', rasp_admin_views.get_configuration, name='configuration'),
    url(r'settings/$', rasp_admin_views.get_settings, name='settings'),

    url(r'^mds_files_viewer/', include('travel.rasp.admin.mds_files_viewer.urls')),
    url(r'^validation/', include('cysix.validation.urls')),
    url(r'^timecorrection/', include('travel.rasp.admin.timecorrection.urls', namespace='timecorrection')),

    url(r'^tanker-action/$', tanker.action, name='tanker_action'),

    url(r'find_packages_to_reload_to_use_is_base/$', rasp_admin_views.find_packages_to_reload_to_use_is_base,
        name='find_packages_to_reload_to_use_is_base'),

    url(r'^dynamic_settings/?$', dynamic_settings.list_view, name='dynamic_settings_list'),
    url(r'^dynamic_settings/save_setting/?$', dynamic_settings.save_setting, name='dynamic_settings_save_setting'),
    url(r'^dynamic_settings/raw/([\w_]+)/$', dynamic_settings.raw_setting_data, name='dynamic_settings_raw'),

    url(r'^flags/maintenance/get/?$', flags.get_maintenance_flag),
    url(r'^flags/maintenance/set/?$', flags.set_maintenance_flag),
    url(r'^flags/maintenance/unset/?$', flags.unset_maintenance_flag),

    url(r'^local/flags/maintenance/get/?$', flags.local_get_maintenance_flag),
    url(r'^local/flags/maintenance/set/?$', flags.local_set_maintenance_flag),
    url(r'^local/flags/maintenance/unset/?$', flags.local_unset_maintenance_flag),

    url(r'^deploy/flags/maintenance/set/?$', flags.set_maintenance_flag_deploy),

    url(r'', include(admin.site.urls)),
]
