# -*- coding: utf-8 -*-

import os.path
import codecs

from django.conf import settings
from django.http import HttpResponse


def render(options, lang):
    import hemi

    path = os.path.join(
        settings.STATIC_ROOT,
        'rasp/geoadmins/desktop.bundles/index',
        'index.%s.priv.js' % lang
    )
    with codecs.open(path, 'r', encoding='utf-8') as f:
        source = f.read()

    context = hemi.Context()
    context.eval(source)
    bemjson = context.locals.blocks['b-page'](options)
    html = context.locals.BEMHTML.apply(bemjson)

    return HttpResponse(html, content_type="text/html")
