# -*- coding: utf-8 -*-

from common.utils.httpresponses import jsonp_response
from common.models.geo import StationMajority, Station
from common.models.transport import TransportType
from travel.rasp.admin.importinfo.models.two_stage_import import TwoStageImportPackage
from travel.rasp.admin.www.models.precalc import Suggest

from travel.rasp.admin.admin.utils import permission_required_or_403 as permission_wrapper


def permission_required_or_403(func):
    return permission_wrapper(func, 'importinfo.change_stationmapping')


@permission_required_or_403
@jsonp_response
def get_packages(request):
    return {
        'objects': map(packages_json, TwoStageImportPackage.objects.all())
    }


@permission_required_or_403
@jsonp_response
def get_data(request):
    return {
        'stationMajorities': map(object_with_code_json, StationMajority.objects.all()),
        'transportTypes': map(object_with_code_json, TransportType.objects.all())
    }


@permission_required_or_403
@jsonp_response
def search_station(request):
    text = request.POST['query'] if 'query' in request.POST else request.GET['query']

    try:
        return [station_json(Station.objects.get(id=int(text)))]

    except (Station.DoesNotExist, ValueError):
        pass

    variants = Suggest.station(text, request.client_city, 'any')

    if not variants:
        return []

    return [_station_suggest_json(v) for v in variants]


def _station_suggest_json(suggest):
    station = Station.objects.get(id=suggest.object_id)

    return station_json(station)


def station_json(station):
    return {
        'id': station.id,
        'title': u'%s (%s)' % (station.L_title(), station.t_type.code),
        'lon': station.longitude,
        'lat': station.latitude,
        't_type_id': station.t_type_id,
        't_type': TransportType.objects.get(id=station.t_type_id).code
    }


def object_json(o):
    return {
        'id': o.id if o else '',
        'title': o.L_title() if o else ''
    }


def object_with_code_json(o):
    return {
        'id': o.id if o else '',
        'code': o.code if o else '',
        'title': o.L_title() if o else ''
    }


def packages_json(o):
    return {
        'id': o.id,
        'title': o.title,
        't_type_code': o.t_type.code
    }
