# coding: utf-8

from __future__ import unicode_literals

import logging
import sys
import os

from django.conf import settings
from django.contrib import messages
from django.shortcuts import redirect
from django.template.response import TemplateResponse
from subprocess import check_output, CalledProcessError

from travel.rasp.admin.admin.admin_tasks import get_task_log_blocks, TaskLog, run_task
from travel.rasp.admin.lib.adminutils import superuser_required


log = logging.getLogger(__name__)


TASK_NAME = 'tanker_actions'
AVAILABLE_ACTIONS = {'download', 'upload'}


@superuser_required
def action(request):
    if request.method == 'POST':
        keysets = request.POST.getlist('keysets')
        if not keysets:
            messages.error(request, 'Не выбрано ни одного кейсета.')
        else:
            if 'download' in request.POST:
                run_tanker_action(action='download', keysets=keysets)
                messages.info(request, 'Запустили выгрузку из танкера.')
            elif 'upload' in request.POST:
                run_tanker_action(action='upload', keysets=keysets)
                messages.info(request, 'Запустили загрузку в танкер.')
            else:
                messages.error(request, 'Неизвесное действик с танкером.')

        return redirect(request.META['HTTP_REFERER'])

    return TemplateResponse(request, 'raspadmin/tanker_action.html', {
        'title': 'Работа с танкером',
        'task_log_blocks': get_task_log_blocks(TASK_NAME)
    })


def run_tanker_action(action, keysets):
    task_log = TaskLog(TASK_NAME, filename_suffix='{}-{}'.format(action, '__'.join(keysets)))
    run_task(task_log, tanker_action, args=(action, keysets))


def tanker_action(action, keysets):
    if action not in AVAILABLE_ACTIONS:
        log.error('Неизвестное действие "%s".', action)
        return
    log.info('Action %s, keysets %s', action, keysets)
    process_env = os.environ.copy()
    process_env.update({'Y_PYTHON_ENTRY_POINT': 'travel.rasp.admin.scripts.i18n.dbtanker'})
    for keyset in keysets:
        try:
            output = check_output((sys.executable, action, 'generic', keyset),
                                  env=process_env, cwd=settings.PROJECT_PATH)
            log.info(output)
        except CalledProcessError, e:
            log.error(e.output)
