# -*- coding: utf-8 -*-

from common.models.transport import TransportType


def json_www_station(s):
    t_type = TransportType.objects.get(id=s.t_type_id)

    return {
        'id': s.id,
        'title': s.title,
        'lon': s.longitude,
        'lat': s.latitude,
        'settlement': s.settlement_id and {'id': s.settlement_id},
        'geoadmin_link': '/admin/www/station/%s/' % s.id,
        't_type': t_type.code,
        't_type_id': s.t_type_id,
        'majority_id': s.majority_id,
    }
