# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django import forms
from django.contrib import admin

from common.apps.suburban_events.models import ForecastRepresentation
from travel.rasp.admin.lib.admin_options import RaspExportModelAdmin


class ForecastRepresentationModelForm(forms.ModelForm):
    def clean(self):
        cleaned_data = super(ForecastRepresentationModelForm, self).clean()
        minutes_from = cleaned_data.get('minutes_from')
        minutes_to = cleaned_data.get('minutes_to')
        if minutes_from or minutes_to:
            return cleaned_data
        else:
            raise forms.ValidationError('Представление прогноза должно содержать хотя бы одну границу')


@admin.register(ForecastRepresentation)
class ForecastRepresentationAdmin(RaspExportModelAdmin):
    form = ForecastRepresentationModelForm

    list_display = ('type', 'delay_from', 'delay_to', 'deep_from', 'deep_to')
