# coding: utf-8

from __future__ import unicode_literals

from rasp_vault.api import get_secret

from common.settings.db import WorkInstance, ServiceInstance
from common.settings.configuration import BaseConfigurator
from common.settings.utils import use_master_only, get_cache_config


def fix_ipv6_host(host):
    return 'inet6:[%s]' % host


class MiscAdminConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['MONGO_DATABASES']['default'].setdefault('options', {})['socketTimeoutMS'] = None

        settings['TVM_SERVICE_ID'] = 2012108
        settings['TVM_DESTINATIONS'] = ['TVM_MAPS_API', 'TVM_BLACKBOX_YATEAM']
        settings['TVM_SECRET'] = get_secret('rasp-admin-testing.TVM_SECRET')
        settings['TVM_IDM_CLIENT_IDS'] = {
            2001600  # idm_production
        }

    def apply_production(self, settings):
        use_master_only(settings)

        settings['EMAIL_BACKEND'] = 'django.core.mail.backends.smtp.EmailBackend'
        settings['ENVIRONMENT'] = 'production'

        # !!!!!! Осторожнее с копированием этих настроек
        settings['SEND_MAIL_TO_PARTNERS'] = True

        settings['SYNC_WITH_SERP'] = True
        # ----!!!!!

        settings['BILLING_HOST'] = 'csbi-http-api.yandex.net'

        settings['SEND_CHANGES_REMINDERS'] = True
        settings['REMINDERS_HOST'] = 'reminders-api.yandex.net'

        settings['OLVEN_USER'] = "yandex4"

        # для особо долгих скриптов
        settings['MYSQL_READ_TIMEOUT'] = settings['MYSQL_WRITE_TIMEOUT'] = 3600 * 5

        settings['SUBURBAN_CHANGE_NOTICES_FROM_EMAIL'] = '"Rasp Info" <rasp-info@yandex-team.ru>'

        settings['DOMAIN_NAMES'] = {
            ServiceInstance.code: settings['PROD_SERVICE_URL'],
            WorkInstance.code: settings['PROD_WORK_URL']
        }

        settings['DOMAIN_NAME'] = settings['DOMAIN_NAMES'][settings['INSTANCE_ROLE'].code]

        settings['MEDIA_URL'] = '/media/'

        if settings['SERVICE_INSTANCE']:
            settings['MORDA_LINK'] = 'https://production-service-db.old-morda-python.rasp.common.yandex.ru'
        else:
            settings['MORDA_LINK'] = 'https://production-work-db.old-morda-python.rasp.common.yandex.ru'

        settings['YMAPS_KEY'] = 'AEp5zEoBAAAAfL_cJgMAUSHv-GWok27r4hnjZuuG9upgDlMAAAAAAAAAAACMS8LL7CME6VCRRfPe7cjnx' \
                                'BX0mQ==~AOgFllEBAAAAOnoASQMAx2fICl4Mk6S0vBFGKQbvSi1tnIoAAAAAAAAAAADPBjdQsi_hv3DLJc' \
                                '1MNBEEs9JHfA=='

        settings['AVIA_PARTNER_FETCH_SUBJECT'] = 'production'
        settings['AVIA_PARTNER_FETCH_MAIL'] = 'avia-partner-fetch-errors@yandex-team.ru'

        settings['TICKETS_QUERY_URL'] = 'https://daemon.avia.yandex.net/api/1.0/'

        settings['TVM_SERVICE_ID'] = 2012110
        settings['TVM_SECRET'] = get_secret('rasp-admin-production.TVM_SECRET')

    def apply_testing(self, settings):
        use_master_only(settings)

        settings['ENVIRONMENT'] = 'testing'

        settings['TEST_WIZARD'] = False

        settings['SEND_CHANGES_REMINDERS'] = False
        settings['REMINDERS_HOST'] = 'reminders-api.calendar-back01e.tst.corba.yandex.net'

        settings['EMAIL_BACKEND'] = 'travel.rasp.admin.lib.redirect_email_backend.EmailBackend'
        settings['REDIRECT_EMAILS'] = ['rasp-testing@yandex-team.ru']

        settings['SUBURBAN_CHANGE_NOTICES_FROM_EMAIL'] = '"Rasp Info Testing" <rasp-info@yandex-team.ru>'

        settings['OLVEN_USER'] = 'yandex'
        settings['YMAPS_KEY'] = "AG8TgVABAAAA6if9CQMAGGDnGftF2Wdi31LQ-1Ixe_B6eUsAAAAAAAAAAABy1iWC_h8nPrHXmtiCbqUp" \
                                "F54krw==~AOoedVEBAAAArqhKdAMAd6qYylXzI5h6xIyI2qrQRUO2EyMAAAAAAAAAAAA7nhKONxVAMa7" \
                                "9HGoUrSzy97Dd6w=="

        settings['CACHES'] = {
            'admin': get_cache_config(['admin-test.rasp.yandex.ru']),
        }
        settings['CACHES']['default'] = settings['CACHES'].pop('admin')

        settings['DOMAIN_NAMES'] = {
            ServiceInstance.code: settings['TEST_SERVICE_URL'],
            WorkInstance.code: settings['TEST_WORK_URL']
        }

        settings['DOMAIN_NAME'] = settings['DOMAIN_NAMES'][settings['INSTANCE_ROLE'].code]

        settings['MEDIA_URL'] = '/media/'

        if settings['SERVICE_INSTANCE']:
            settings['MORDA_LINK'] = 'https://testing-service-db.old-morda-python.rasp.common.yandex.ru'
        else:
            settings['MORDA_LINK'] = 'https://testing-work-db.old-morda-python.rasp.common.yandex.ru'

        settings['POPULAR_DIRECTIONS_IMPORT_PROXY'] = 'kant.yt.yandex.net'

        settings['AVIA_PARTNER_FETCH_SUBJECT'] = 'testing'
        settings['AVIA_PARTNER_FETCH_MAIL'] = 'avia-partner-fetch-errors@yandex-team.ru'

        settings['TICKETS_QUERY_URL'] = 'https://daemon.avia.lepus.yandex.net/api/1.0/'

        settings['LOAD_LATEST_DB_ALLOWED'] = True
        settings['LOAD_LATEST_DB_TMP_DATABASE'] = 'rasp_tmp'

    def apply_development(self, settings):
        settings['BILLING_HOST'] = 'csbi-http-api.yandex.net'

        settings['OLVEN_USER'] = "yandex4"

        settings['DATABASES']['default']['USER'] = 'rasp'
        settings['DATABASES']['default']['PASSWORD'] = 'rasp'
        settings['DATABASES']['default']['HOST'] = 'localhost'

        settings['LOAD_LATEST_DB_ALLOWED'] = True
        settings['LOAD_LATEST_DB_TMP_DATABASE'] = 'rasp_tmp'
        settings['LOAD_LATEST_DB_GRANT_SUPERUSER'] = True
        settings['LOAD_LATEST_DB_FULL'] = False
