# -*- coding: utf-8 -*-

import os.path

LOGGING_FORMAT = '%(name)s %(process)d %(asctime)s %(levelname)s: %(message)s'


def configure_logs(settings, log_path, tree_log_level='INFO'):
    # Подгружаем фиксы логирования для админки
    import travel.rasp.admin.lib.logs  # noqa

    settings['LOG_FORMAT'] = LOGGING_FORMAT
    settings['LOG_COLLECTOR_FORMAT'] = u'%(levelname)s: %(message)s'
    settings['LOGGING_FORMAT'] = LOGGING_FORMAT
    settings['WARNING_LOG_PATH'] = os.path.join(log_path, 'warning.log')
    settings['ADMIN_LOG_PATH'] = os.path.join(log_path, 'admin.log')

    settings['LOGGING'] = {
        'version': 1,
        'disable_existing_loggers': True,
        'formatters': {
            'verbose': {
                '()': 'travel.rasp.admin.lib.logs.ContextRaspFormatter',
                'format': LOGGING_FORMAT
            },
            'exception': {
                '()': 'ylog.ExceptionFormatter',
                'format': LOGGING_FORMAT,
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': LOGGING_FORMAT,
                'full': True,
                'show_locals': True
            },
            'json_formatter': {
                '()': 'travel.rasp.admin.lib.logs.JsonFormatterContextKeys',
                'context_field': 'yt_context',
                'keys_to_log': {'levelname', 'process', 'yt_context', 'name'}
            }
        },
        'filters': {
            'require_debug_false': {
                '()': 'django.utils.log.RequireDebugFalse'
            },
            'exclude_from_tree': {
                '()': 'travel.rasp.library.python.common23.logging.ExcludeFromTree',
                'starts_with_names': ('special.',),
                'exact_names': ('__main__',)  # Запуск скрипта нужно логировать lib.logs.create_current_file_run_log
            },
            'context_filter': {
                '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
                'as_dict': True,
                'context_field': 'yt_context'
            },
        },
        'handlers': {
            'tree_handler': {
                'level': tree_log_level,
                'class': 'travel.rasp.library.python.common23.logging.FileTreeHandler',
                'base_path': os.path.join(log_path, 'tree'),
                'formatter': 'verbose',
                'filters': ['exclude_from_tree']
            },
            'exception': {
                'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                'filename': os.path.join(log_path, 'exception.log'),
                'formatter': 'exception',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                'filename': os.path.join(log_path, 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            },
            'yt.tree': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(log_path, 'yt', 'tree.log'),
                'formatter': 'json_formatter',
                'filters': ['context_filter'],
                'level': 'INFO'
            },
        },
        'loggers': {
            'django': {
                'handlers': ['exception', 'traceback'],
                'level': tree_log_level,
            }
        },

        'root': {
            'handlers': ['tree_handler', 'yt.tree'],
            'level': tree_log_level,
        }
    }
