# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.core.exceptions import ValidationError
from django.utils.encoding import smart_unicode

from cysix.filter_parameters import FilterParameters


# https://docs.djangoproject.com/en/1.3/howto/custom-model-fields/
class PackageFilterParametersField(models.TextField):
    description = _(u"Параметры фильтров для общего xml-формата")

    def to_python(self, value):
        if isinstance(value, FilterParameters):
            return value

        if isinstance(value, basestring):
            return FilterParameters(unicode(value))

        else:
            return FilterParameters(u'[]')

    def from_db_value(self, value, expression, connection, context):
        if value is None:
            return value
        return self.to_python(value)

    def get_prep_value(self, value):
        if isinstance(value, FilterParameters):
            return value.get_string()

        elif isinstance(value, basestring):
            return smart_unicode(value)

        else:
            return u''

    def validate(self, value, model_instance):
        # (1) Приводим все к нашим параметрам
        if not isinstance(value, FilterParameters):
            try:
                value = FilterParameters(value, strict=True)

            except ValueError:
                raise ValidationError(u'Критическая ошибка в параметрах')

        # (2) Проверим что ничего нового не появилось.
        # Все параметры как и по умолчанию. Значения могут отличаться.
        from models import PackageFilter

        if isinstance(model_instance, PackageFilter):
            _default_parameters = model_instance.filter.default_parameters  # noqa

            # Так можно установить дефолтные параметры.
            # parameters_to_save.set_parameters(default_parameters.get_parameters())

        # (3) Теперь проверим сами значения
        value.validate_values()
