# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


def apply_base_stations(rtstations):
    apply_flags = False
    for rts in rtstations[1:]:
        if rts.station.is_base:
            apply_flags = True
        if apply_flags:
            rts.in_station_schedule = False
            rts.is_searchable_from = False

    return rtstations


def station_is_trusted(station, package, group, is_first):
    if package.trusted_stations:  # есть опорные
        if not group:
            return (station.id, None) in package.trusted_stations
        return (station.id, group.id) in package.trusted_stations or (station.id, None) in package.trusted_stations
    return is_first  # логика базовых автовокзалов


def apply_base_and_trusted_stations(rtstations, package, group=None):
    if not package.new_trusted:
        apply_flags = False
        for index, rts in enumerate(rtstations):
            if rts.station.is_base:
                is_first = index == 0
                if station_is_trusted(rts.station, package, group, is_first):
                    apply_flags = False
                else:
                    apply_flags = True
            if apply_flags:
                rts.in_station_schedule = False
                rts.is_searchable_from = False

        return rtstations
    else:
        thread_trusted = package.new_trusted_stations(group)
        thread_not_trusted = package.new_not_trusted_stations(group)
        apply_flags = False
        for index, rts in enumerate(rtstations):
            if rts.station.id in thread_not_trusted:
                apply_flags = True
            elif rts.station.id in thread_trusted:
                apply_flags = False
            if apply_flags:
                rts.in_station_schedule = False
                rts.is_searchable_from = False

        return rtstations
