# -*- coding: utf-8 -*-

import logging

from django.utils.translation import gettext_noop as N_

log = logging.getLogger(__name__)


def clear_consecutive_duplicate_rtstations(rtstations):
    if not rtstations:
        return rtstations

    new_rtstations = [rtstations[0]]

    prev_station = rtstations[0].station

    for rts in rtstations[1:]:
        if rts.station is not None and rts.station == prev_station:
            log.info(
                N_(
                    u'Встретились идущее подряд остановки, привязанные к одной станции %s. '
                    u'Оставляем только первую.'
                ),
                rts.station
            )

            continue

        prev_station = rts.station

        new_rtstations.append(rts)

    return new_rtstations
