# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
from UserList import UserList

from django.utils.translation import gettext_noop as N_


from travel.rasp.admin.scripts.schedule.utils import RaspImportError


log = logging.getLogger(__name__)


class BaseFilter(object):
    """
    _items и _item нужно заменять на более удобные имена в контексте
    """
    def process(self, _items):
        for _item in _items:
            for new_item in self.process_item(_item):
                yield new_item

    def process_item(self, _item):
        yield _item


class Pipeline(UserList):
    def process(self, items):
        for filter_ in self:
            items = filter_.process(items)

        return items


class SkipOnRaspImportErrorFilter(BaseFilter):
    def process(self, _items):
        for item in _items:
            try:
                for new_item in self.process_item(item):
                    yield new_item
            except RaspImportError as e:
                log.error(N_(u'%s: %s'), item, e)
            except Exception:
                log.exception(N_(u'Неожиданная ошибка %s'), item)
