# -*- coding: utf-8 -*-

import logging

from django.utils.translation import gettext_noop as N_


log = logging.getLogger(__name__)

MINUTES_IN_DAY = 24 * 60


class Filter(object):
    def __init__(self, params):
        self.params = params

    def apply(self, rtstations, standard_stop_time):
        if self.params:
            self.t_max = self.params['t_max']
            self.standard_stop_time = standard_stop_time

            rtstations = self.fill_can_add_day(rtstations)

            if self.params['only_add_day']:
                rtstations = self.correct_stop_time_only_add_day(rtstations)

            else:
                rtstations = self.correct_stop_time(rtstations)

        return rtstations

    def correct_stop_time(self, rtstations):
        for rts in rtstations:
            self.correct_stop_time_for_rtstation(rts)

        return rtstations

    def correct_stop_time_for_rtstation(self, rts):
        if rts.departure is None or rts.arrival is None:
            return

        origin_stop_time = rts.departure - rts.arrival

        if rts.can_add_day:
            while rts.departure < rts.arrival:
                log.info(
                    N_(
                        u"Фильтр коррекции времени стоянки: "
                        u"добавляем сутки к времени отправления для станции '%s'"
                    ),
                    rts.station.title
                )
                rts.departure += MINUTES_IN_DAY

        stop_time = rts.departure - rts.arrival

        if stop_time > self.t_max or rts.departure < rts.arrival:
            log.warning(
                N_(
                    u"Не получилось скорректировать время стоянки '%s' для станции '%s'."
                    u" Исправляем на стандартную стоянку %s минута."
                ),
                origin_stop_time,
                rts.station.title,
                self.standard_stop_time
            )
            rts.departure = rts.arrival + self.standard_stop_time

    def correct_stop_time_only_add_day(self, rtstations):
        for rts in rtstations:
            self.correct_stop_time_for_rtstation_only_add_day(rts)

        return rtstations

    def correct_stop_time_for_rtstation_only_add_day(self, rts):
        if rts.departure is None or rts.arrival is None:
            return

        origin_stop_time = rts.departure - rts.arrival

        if rts.can_add_day_to_departure:
            while rts.departure < rts.arrival:
                log.info(
                    N_(
                        u"Фильтр коррекции времени стоянки: "
                        u"добавляем сутки к времени отправления для станции '%s'"
                    ),
                    rts.station.title
                )
                rts.departure += MINUTES_IN_DAY

        if rts.departure < rts.arrival:
            log.warning(
                N_(
                    u"Не получилось скорректировать время стоянки '%s' для станции '%s'."
                    u" Исправляем на стандартную стоянку %s минута."
                ),
                origin_stop_time,
                rts.station.title,
                self.standard_stop_time
            )
            rts.departure = rts.arrival + self.standard_stop_time
            rts.can_add_day_to_departure = rts.can_add_day_to_arrival

    def fill_can_add_day(self, rtstations):
        if not self.params['trust_day_shift']:
            return self.set_can_add_day_to_true(rtstations)

        for rts in rtstations:
            rts.can_add_day = rts.supplier_rtstation.can_add_day
            rts.can_add_day_to_departure = rts.supplier_rtstation.can_add_day_to_departure
            rts.can_add_day_to_arrival = rts.supplier_rtstation.can_add_day_to_arrival

        return rtstations

    def set_can_add_day_to_true(self, rtstations):
        for rts in rtstations:
            rts.can_add_day = True
            rts.can_add_day_to_arrival = True
            rts.can_add_day_to_departure = True

        return rtstations
