# -*- coding: utf-8 -*-

from cysix.filters.core.base import SkipOnRaspImportErrorFilter


class SkipStationWithoutTimes(SkipOnRaspImportErrorFilter):
    def process_item(self, xml_thread):
        yield self.apply(xml_thread)

    def apply(self, xml_thread):
        xml_thread.supplier_rtstations = [
            supplier_rtstation
            for supplier_rtstation in xml_thread.supplier_rtstations
            if self.times_is_filled(supplier_rtstation)
        ]

        return xml_thread

    def times_is_filled(self, supplier_rtstation):
        time_fields = ('arrival_time', 'departure_time', 'arrival_minutes_shift', 'departure_minutes_shift')

        for time_field in time_fields:
            if getattr(supplier_rtstation, time_field) is not None:
                return True
        return False


class Filter(object):
    def __init__(self, params):
        self.params = params

    def add_to_pipeline(self, pipeline):
        if self.params is not None:
            pipeline.append(SkipStationWithoutTimes())

    def apply(self, xml_thread):
        filter_ = SkipStationWithoutTimes()
        return filter_.apply(xml_thread)
