# -*- coding: utf-8 -*-


class Filter(object):
    def __init__(self, params):
        self.params = params

    def apply(self, rtstation):
        if self.params:
            self._update_flags(rtstation)

    def _update_flags(self, rtstation):
        if rtstation.is_fuzzy:
            rtstation.is_searchable_from = self.params['is_searchable_from']
            rtstation.is_searchable_to = self.params['is_searchable_to']
            rtstation.in_station_schedule = self.params['in_station_schedule']
            rtstation.in_thread = self.params['in_thread']
